﻿using System;
using System.Globalization;
using System.Windows.Data;

namespace Microscopic_Traffic_Simulator.Converters
{
    /// <summary>
    /// Converter from UICulture name string to checked status of checkbox item.
    /// </summary>
    class FromUICultureNameToItemChecked : IValueConverter
    {
        /// <summary>
        /// Convert UICulture name string to status of checkbox item.
        /// </summary>
        /// <param name="value">UICulture string.</param>
        /// <param name="targetType">Target type of checkbox status.</param>
        /// <param name="parameter">Parameter defined in UI. For each item of checkbox is 
        /// parameter set to UI culture string of associated language.</param>
        /// <param name="culture">Current culture info.</param>
        /// <returns>True/False whether checkbox item to be checked or not.</returns>
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if ((string)value == (string)parameter)
                return true;
            else
                return false;
        }

        /// <summary>
        /// Convert status of checkbox item to UI culture string. Should not be used.
        /// </summary>
        /// <param name="value">Checkbox item status.</param>
        /// <param name="targetType">Target type of UI culture string.</param>
        /// <param name="parameter">Parameter defined in UI. For each item of checkbox is 
        /// parameter set to UI culture string of associated language.</param>
        /// <param name="culture">Current culture info.</param>
        /// <returns>UICulture string.</returns>
        public object ConvertBack(object value, Type targetType, object parameter,
            CultureInfo culture)
        {
            return null;
        }
    }
}
